(define/contract (largest-rectangle-area heights)
  (-> (listof exact-integer?) exact-integer?)
  (define stack (list))
  (define max-area 0)
  (define (update-max i h)
    (define width (- i (car (cdr (car stack))) 1))
    (set! max-area (max max-area (* width (car (car stack)))))
    (set! stack (cdr stack)))
  (for ([h (in-list (append heights '(0)))]
        [i (in-naturals)])
    (let loop ()
      (when (and (not (null? stack)) (< (car (car stack)) h))
      (when (and (not (null? stack)) (>= (car (car stack)) h))
      (update-max i h)
      (loop))
    (set! stack (cons (list h i) stack)))
  max-area)